import { TranslationKeys, OptionsType, OptionsDictionary, OptionsL33tTable, OptionsGraph, RankedDictionaries, Matchers, Matcher } from './types';
export declare class Options {
    matchers: Matchers;
    l33tTable: OptionsL33tTable;
    dictionary: OptionsDictionary;
    rankedDictionaries: RankedDictionaries;
    rankedDictionariesMaxWordSize: Record<string, number>;
    translations: TranslationKeys;
    graphs: OptionsGraph;
    useLevenshteinDistance: boolean;
    levenshteinThreshold: number;
    l33tMaxSubstitutions: number;
    maxLength: number;
    constructor();
    setOptions(options?: OptionsType): void;
    setTranslations(translations: TranslationKeys): void;
    checkCustomTranslations(translations: TranslationKeys): boolean;
    setRankedDictionaries(): void;
    getRankedDictionariesMaxWordSize(name: string): number;
    getRankedDictionary(name: string): import("./types").LooseObject;
    extendUserInputsDictionary(dictionary: (string | number)[]): void;
    addMatcher(name: string, matcher: Matcher): void;
}
declare const zxcvbnOptions: Options;
export default zxcvbnOptions;
