
const express = require('express');
const router = express.Router();
const multer = require('multer');
const upload = multer({ dest: 'src/uploads/' });
const { uploadVerification, adminVerify } = require('../controllers/verifyController');
const { authenticateJWT } = require('../middleware/auth');
const requireRole = require('../middleware/requireRole');

router.post('/upload', upload.fields([{ name: 'gov_id' }, { name: 'signature' }]), uploadVerification);
router.post('/admin/verify/:id', authenticateJWT, requireRole('admin'), adminVerify);

module.exports = router;
