
const express = require('express');
const router = express.Router();
const { createTrack, listTracks } = require('../controllers/trackController');
const { authenticateJWT } = require('../middleware/auth');
const requireRole = require('../middleware/requireRole');

router.post('/', authenticateJWT, requireRole('artist'), createTrack);
router.get('/', authenticateJWT, listTracks);

module.exports = router;
