
const express = require('express');
const router = express.Router();
const { createAlbum, listAlbums } = require('../controllers/albumController');
const { authenticateJWT } = require('../middleware/auth');
const requireRole = require('../middleware/requireRole');

router.post('/', authenticateJWT, requireRole('artist'), createAlbum);
router.get('/', authenticateJWT, listAlbums);

module.exports = router;
