
const { Model, DataTypes } = require('sequelize');

class UserRole extends Model {
  static init(sequelize) {
    return super.init({
      id: { type: DataTypes.BIGINT.UNSIGNED, primaryKey: true, autoIncrement: true },
      tenant_id: { type: DataTypes.UUID, allowNull: false },
      user_id: { type: DataTypes.BIGINT.UNSIGNED, allowNull: false },
      role_id: { type: DataTypes.BIGINT.UNSIGNED, allowNull: false }
    }, { sequelize, tableName: 'user_roles', timestamps: false });
  }
}

module.exports = UserRole;
