
const { Model, DataTypes } = require('sequelize');

class Tenant extends Model {
  static init(sequelize) {
    return super.init({
      tenant_id: { type: DataTypes.UUID, defaultValue: DataTypes.UUIDV4, primaryKey: true },
      name: { type: DataTypes.STRING, allowNull: false },
      slug: { type: DataTypes.STRING, allowNull: false, unique: true },
      status: { type: DataTypes.STRING, defaultValue: 'active' }
    }, { sequelize, tableName: 'tenants' });
  }

  static associate() {
    const models = require('./index');
    // associations set in other models where needed
  }
}

module.exports = Tenant;
