
const sequelize = require('../config/database');
const User = require('./user');
const Tenant = require('./tenant');
const Role = require('./role');
const UserRole = require('./userRole');
const Album = require('./album');
const Track = require('./track');
const Notification = require('./notification');
const Message = require('./message');
const RoyaltyLedger = require('./royaltyLedger');

// initialize models
Tenant.init(sequelize);
Role.init(sequelize);
User.init(sequelize);
UserRole.init(sequelize);
Album.init(sequelize);
Track.init(sequelize);
Notification.init(sequelize);
Message.init(sequelize);
RoyaltyLedger.init(sequelize);

// Associations
Tenant.associate && Tenant.associate();
Role.associate && Role.associate();
User.associate && User.associate();
UserRole.associate && UserRole.associate();
Album.associate && Album.associate();
Track.associate && Track.associate();
Notification.associate && Notification.associate();
Message.associate && Message.associate();
RoyaltyLedger.associate && RoyaltyLedger.associate();

module.exports = {
  sequelize,
  Tenant,
  User,
  Role,
  UserRole,
  Album,
  Track,
  Notification,
  Message,
  RoyaltyLedger
};
