
const { Model, DataTypes } = require('sequelize');

class Album extends Model {
  static init(sequelize) {
    return super.init({
      album_id: { type: DataTypes.BIGINT.UNSIGNED, autoIncrement: true, primaryKey: true },
      tenant_id: { type: DataTypes.UUID, allowNull: false },
      artist_id: { type: DataTypes.BIGINT.UNSIGNED, allowNull: false },
      title: { type: DataTypes.STRING, allowNull: false },
      genre: { type: DataTypes.STRING },
      cover_art_url: { type: DataTypes.STRING },
      release_date: { type: DataTypes.DATE }
    }, { sequelize, tableName: 'albums' });
  }

  static associate() {
    const { User } = require('./index');
    this.belongsTo(User, { foreignKey: 'artist_id', as: 'artist' });
  }
}

module.exports = Album;
