
const roleLevels = { editor: 1, supervisor: 2, manager: 3, admin: 4 };

function requireRole(minRoleKey) {
  return (req, res, next) => {
    if (!req.user) return res.status(401).json({ error: 'Unauthenticated' });
    const userRole = req.user.role;
    const userLevel = roleLevels[userRole] || 0;
    const minLevel = roleLevels[minRoleKey] || 0;
    if (userLevel >= minLevel) return next();
    return res.status(403).json({ error: 'Insufficient role' });
  };
}

module.exports = requireRole;
