
const jwt = require('jsonwebtoken');
const { User } = require('../models');
require('dotenv').config();

const jwtSecret = process.env.JWT_SECRET || 'changeme';

async function authenticateJWT(req, res, next) {
  const auth = req.headers.authorization;
  if (!auth || !auth.startsWith('Bearer ')) return res.status(401).json({ error: 'Missing token' });
  const token = auth.slice(7);
  try {
    const payload = jwt.verify(token, jwtSecret);
    const user = await User.findOne({ where: { user_id: payload.user_id, tenant_id: payload.tenant_id } });
    if (!user) return res.status(401).json({ error: 'User not found' });
    req.user = user;
    req.tenant = { tenant_id: payload.tenant_id };
    next();
  } catch (err) {
    console.error(err);
    return res.status(401).json({ error: 'Invalid token' });
  }
}

module.exports = { authenticateJWT };
