
const { User } = require('../models');

async function uploadVerification(req, res) {
  try {
    const { user_id, full_name, address } = req.body;
    if (!req.files || !req.files.gov_id || !req.files.signature) {
      return res.status(400).json({ error: 'gov_id and signature files required' });
    }
    const user = await User.findByPk(user_id);
    if (!user) return res.status(404).json({ error: 'User not found' });
    user.full_name = full_name;
    user.address = address;
    user.gov_id_url = req.files.gov_id[0].path;
    user.signature_url = req.files.signature[0].path;
    user.verification_status = 'pending';
    await user.save();
    res.json({ ok: true, message: 'Verification submitted' });
  } catch (err) {
    console.error(err);
    res.status(500).json({ error: 'Upload failed' });
  }
}

async function adminVerify(req, res) {
  try {
    const { id } = req.params;
    const { approve } = req.body;
    const user = await User.findByPk(id);
    if (!user) return res.status(404).json({ error: 'User not found' });
    user.verification_status = approve ? 'verified' : 'rejected';
    await user.save();
    if (approve) await User.promoteToArtist(id);
    res.json({ ok: true, user });
  } catch (err) {
    console.error(err);
    res.status(500).json({ error: 'Verification failed' });
  }
}

module.exports = { uploadVerification, adminVerify };
