
const jwt = require('jsonwebtoken');
const { User, Tenant } = require('../models');
require('dotenv').config();

const jwtSecret = process.env.JWT_SECRET || 'changeme';
const jwtExpiry = process.env.JWT_EXPIRES_IN || '7d';

async function register(req, res) {
  try {
    const { tenant_slug, name, email, password } = req.body;
    if (!tenant_slug || !email || !password) return res.status(400).json({ error: 'tenant_slug, email, password required' });
    const tenant = await Tenant.findOne({ where: { slug: tenant_slug } });
    if (!tenant) return res.status(404).json({ error: 'Tenant not found' });
    const user = await User.create({ tenant_id: tenant.tenant_id, name, email });
    await user.setPassword(password);
    await user.save();
    return res.json({ ok: true, user_id: user.user_id });
  } catch (err) {
    console.error(err);
    res.status(500).json({ error: 'Registration failed' });
  }
}

async function login(req, res) {
  try {
    const { tenant_slug, email, password } = req.body;
    if (!tenant_slug || !email || !password) return res.status(400).json({ error: 'required' });
    const tenant = await Tenant.findOne({ where: { slug: tenant_slug } });
    if (!tenant) return res.status(404).json({ error: 'Tenant not found' });
    const user = await User.findOne({ where: { email, tenant_id: tenant.tenant_id } });
    if (!user) return res.status(401).json({ error: 'Invalid credentials' });
    const valid = await user.validPassword(password);
    if (!valid) return res.status(401).json({ error: 'Invalid credentials' });
    const token = jwt.sign({ user_id: user.user_id, tenant_id: user.tenant_id }, jwtSecret, { expiresIn: jwtExpiry });
    res.json({ token, user: { user_id: user.user_id, email: user.email, name: user.name, role: user.role } });
  } catch (err) {
    console.error(err);
    res.status(500).json({ error: 'Login failed' });
  }
}

module.exports = { register, login };
