
const { Album } = require('../models');

async function createAlbum(req, res) {
  try {
    const tenant_id = req.user.tenant_id;
    const { title, genre, release_date } = req.body;
    const artist_id = req.user.user_id;
    const album = await Album.create({ tenant_id, artist_id, title, genre, release_date });
    res.json({ ok: true, album });
  } catch (err) {
    console.error(err);
    res.status(500).json({ error: 'Create album failed' });
  }
}

async function listAlbums(req, res) {
  try {
    const tenant_id = req.user.tenant_id;
    const albums = await Album.findAll({ where: { tenant_id } });
    res.json({ ok: true, albums });
  } catch (err) {
    console.error(err);
    res.status(500).json({ error: 'List albums failed' });
  }
}

module.exports = { createAlbum, listAlbums };
